
  /*
   *  Object %name    : main.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DES parsing functions  
   *
   *  \version parser.c#1:csrc:1
   *  \author mottig
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "CRYS_DES.h"
#include "crysatptest_msg_defs.h"
#include "CRYS_SEP_ATP_Defines.h"
#include "CRYS_SEP_ATP_DES_Acceptance.h"
#include "DX_VOS_Mem.h"

/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/
extern char   FailureFunctionNameOut[TST_FUNC_STRING_LEN];

/**************** Private function prototypes ****************/

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_DESNotIntegratedTest      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application DES not integrated
* DES function.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_DESNotIntegratedTest(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* input data size in bytes: */
	DxUint32_t					SEP_DataInSize; 
	/* input data size word aligned */
	DxUint32_t					SEP_MaxDataInSize; 
	/* expected data size in bytes */
	DxUint32_t					SEP_DataExpSize; 
	/* expected data size word aligned */
	DxUint32_t					SEP_MaxDataExpSize; 
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;
	DxUint8_t*		            SEP_IVCounter;
	DxUint8_t*				    SEP_Key;
	CRYS_DES_NumOfKeys_t        SEP_NumOfKeys;           
	CRYS_DES_EncryptMode_t      SEP_EncryptDecryptFlag;
	CRYS_DES_OperationMode_t    SEP_OperationMode;    
	DxUint8_t*					SEP_DataIn_ptr;
	DxUint8_t*					SEP_ExpectedData_ptr;
	DxUint32_t					SEP_OutputLocation;
	
	/* 1. extract parameters from the message */
	/******************************************/
	SEP_DataInSize = msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATASIZE_IN_OFFSET];

	SEP_DataExpSize = msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATASIZE_EXP_OFFSET];

	SEP_MaxDataInSize = ((SEP_DataInSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	SEP_MaxDataExpSize = ((SEP_DataExpSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_DESNOTINTEGRATED_MSG_LENGTH_IN_WORDS + 
		SEP_MaxDataInSize/4 + SEP_MaxDataExpSize/4;	

	SEP_IVCounter = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_IVCOUNTER_OFFSET];
	SEP_Key = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_KEY_OFFSET];
	SEP_NumOfKeys = (CRYS_DES_NumOfKeys_t)msg[DX_EXT_SEP_HOST_DES_NOINTEG_KEY_TYPE_OFFSET];
	SEP_EncryptDecryptFlag = (CRYS_DES_EncryptMode_t)msg[DX_EXT_SEP_HOST_DES_NOINTEG_ENC_DEC_OFFSET];
	SEP_OperationMode = (CRYS_DES_OperationMode_t)msg[DX_EXT_SEP_HOST_DES_NOINTEG_MODE_OFFSET];
	SEP_DataIn_ptr    = (DxUint8_t *)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATA_IN_OFFSET];
	SEP_ExpectedData_ptr = (DxUint8_t *)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATA_IN_OFFSET + SEP_MaxDataInSize/4];
	SEP_OutputLocation = msg[DX_EXT_SEP_HOST_DES_NOINTEG_OUTPUTLOCATION_OFFSET];


	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_DES_NotIntegrated(
								SEP_IVCounter,
								(CRYS_DES_Key_t*)SEP_Key,
								SEP_NumOfKeys,
								SEP_EncryptDecryptFlag,
								SEP_OperationMode,
								SEP_DataIn_ptr,
								SEP_DataInSize,
								SEP_ExpectedData_ptr,
								SEP_DataExpSize,
								SEP_OutputLocation,
								FailureFunctionNameOut);

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_DESIntegratedTest      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application DES not integrated
* DES function.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_DESIntegratedTest(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t					SEP_Error = DX_SUCCESS;
	/* input data size in bytes: */
	DxUint32_t					SEP_DataInSize; 
	/* input data size word aligned */
	DxUint32_t					SEP_MaxDataInSize; 
	/* expected data size in bytes */
	DxUint32_t					SEP_DataExpSize; 
	/* expected data size word aligned */
	DxUint32_t					SEP_MaxDataExpSize; 
	/* message length in words */
	DxUint32_t					SEP_MsgLengthInWords;
	DxUint8_t*		            SEP_IVCounter;
	DxUint8_t*				    SEP_Key;
	CRYS_DES_NumOfKeys_t        SEP_NumOfKeys;             
	CRYS_DES_EncryptMode_t      SEP_EncryptDecryptFlag;    
	CRYS_DES_OperationMode_t    SEP_OperationMode;        
	DxUint8_t*					SEP_DataIn_ptr;
	DxUint8_t*					SEP_ExpectedData_ptr;
	DxUint32_t					SEP_OutputLocation;
	
	/* 1. extract parameters from the message */
	/******************************************/
	SEP_DataInSize = msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATASIZE_IN_OFFSET];

	SEP_DataExpSize = msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATASIZE_EXP_OFFSET];

	SEP_MaxDataInSize = ((SEP_DataInSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	SEP_MaxDataExpSize = ((SEP_DataExpSize + 3) / sizeof(DxUint32_t)) * sizeof(DxUint32_t);

	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_DESNOTINTEGRATED_MSG_LENGTH_IN_WORDS + 
		SEP_MaxDataInSize/4 + SEP_MaxDataExpSize/4;	

	SEP_IVCounter = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_IVCOUNTER_OFFSET];
	SEP_Key = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_KEY_OFFSET];
	SEP_NumOfKeys = (CRYS_DES_NumOfKeys_t)msg[DX_EXT_SEP_HOST_DES_NOINTEG_KEY_TYPE_OFFSET];
	SEP_EncryptDecryptFlag = (CRYS_DES_EncryptMode_t)msg[DX_EXT_SEP_HOST_DES_NOINTEG_ENC_DEC_OFFSET];
	SEP_OperationMode = (CRYS_DES_OperationMode_t)msg[DX_EXT_SEP_HOST_DES_NOINTEG_MODE_OFFSET];
	SEP_DataIn_ptr    = (DxUint8_t *)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATA_IN_OFFSET];
	SEP_ExpectedData_ptr = (DxUint8_t *)&msg[DX_EXT_SEP_HOST_DES_NOINTEG_DATA_IN_OFFSET + SEP_MaxDataInSize/4];
	SEP_OutputLocation = msg[DX_EXT_SEP_HOST_DES_NOINTEG_OUTPUTLOCATION_OFFSET];


	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_DES_Integrated(
		SEP_IVCounter,
		(CRYS_DES_Key_t*)SEP_Key,
		SEP_NumOfKeys,
		SEP_EncryptDecryptFlag,
		SEP_OperationMode,
		SEP_DataIn_ptr,
		SEP_DataInSize,
		SEP_ExpectedData_ptr,
		SEP_DataExpSize,
		SEP_OutputLocation,
		FailureFunctionNameOut);

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

